/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigTableModelData;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public class VWConfigExposedFieldTableModel
extends AbstractTableModel {
    private final int NUM_COLUMNS = 4;
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_LENGTH = 3;
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_vwTableDef = null;
    private int m_workItemsInQueue = 0;
    private Vector m_rowData = null;
    private JComboBox m_fieldTypeComboBox = null;
    private boolean m_bIsModified = false;
    private int m_nType = 4;
    private int m_nLength = 10;

    public VWConfigExposedFieldTableModel(Frame parent, IVWTableDefinition tableDefinition, int bWorkItemsInQueue) {
        try {
            this.m_parentFrame = parent;
            this.m_vwTableDef = tableDefinition;
            this.m_workItemsInQueue = bWorkItemsInQueue;
            this.initialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
                this.m_fieldTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void addItem(Object aValue) {
        VWDataFieldItem dataFieldItem = null;
        try {
            if (aValue == null || !(aValue instanceof VWDataFieldItem)) {
                return;
            }
            dataFieldItem = (VWDataFieldItem)aValue;
            VWExposedFieldDefinition fieldDef = this.m_vwTableDef.createFieldDefinition(dataFieldItem.getName(), dataFieldItem.getType(), dataFieldItem.getLength());
            if (fieldDef != null) {
                VWConfigTableModelData tableData = new VWConfigTableModelData(fieldDef, 33);
                this.m_rowData.addElement(tableData);
                int nRowIndex = this.m_rowData.size() - 1;
                this.m_bIsModified = true;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (dataFieldItem != null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, dataFieldItem.getName() + " - " + ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
            }
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }

    public void copyItem(int nRowIndex) {
        try {
            String fieldDefName;
            VWExposedFieldDefinition newFieldDef;
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            if (fieldDef != null && (newFieldDef = this.m_vwTableDef.createFieldDefinition(fieldDefName = VWResource.CopyOf.toString(fieldDef.getName()), fieldDef.getFieldType(), fieldDef.getLength())) != null) {
                VWConfigTableModelData tableData = new VWConfigTableModelData(newFieldDef, 33);
                this.m_rowData.addElement(tableData);
                this.m_bIsModified = true;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            if (fieldDef != null) {
                this.m_vwTableDef.deleteFieldDefinition(fieldDef.getName());
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_bIsModified = true;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_vwTableDef = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        if (this.m_fieldTypeComboBox != null) {
            this.m_fieldTypeComboBox.removeAllItems();
            this.m_fieldTypeComboBox = null;
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return new String(" ");
            }
            case 1: {
                return VWResource.FieldName;
            }
            case 2: {
                return VWResource.FieldType;
            }
            case 3: {
                return VWResource.Length;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWExposedFieldDefinition fieldDef = null;
        try {
            VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
            if (tableData != null) {
                fieldDef = (VWExposedFieldDefinition)tableData.getDefinition();
            }
            switch (nColumnIndex) {
                case 0: {
                    if (tableData != null) {
                        return new Integer(tableData.getStatus());
                    }
                    return new Integer(0);
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getName();
                    }
                    return new String();
                }
                case 2: {
                    if (fieldDef != null) {
                        return VWFieldType.getLocalizedString(fieldDef.getFieldType());
                    }
                    return VWFieldType.getLocalizedString(this.m_nType);
                }
                case 3: {
                    if (fieldDef != null && fieldDef.getFieldType() == 2) {
                        return Integer.toString(fieldDef.getLength());
                    }
                    if (fieldDef == null && this.m_nType == 2) {
                        return Integer.toString(this.m_nLength);
                    }
                    return new String();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
                if (fieldDef != null && fieldDef.getFieldType() == 2) {
                    return true;
                }
                return fieldDef == null && this.m_nType == 2;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.onUpdateFieldName(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateFieldType(aValue, nRowIndex);
                break;
            }
            case 3: {
                this.onUpdateFieldLength(aValue, nRowIndex);
            }
        }
    }

    private void initialize() {
        try {
            this.m_rowData = new Vector();
            VWExposedFieldDefinition[] fieldDefs = this.m_vwTableDef.getFields();
            if (fieldDefs != null && fieldDefs.length > 0) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    VWConfigTableModelData tableData;
                    if (fieldDefs[i].isSystemField() || (tableData = new VWConfigTableModelData(fieldDefs[i], 0)) == null) continue;
                    this.m_rowData.addElement(tableData);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateFieldName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            if (fieldDef != null) {
                if (VWStringUtils.compare(fieldDef.getName(), aValue.toString()) != 0) {
                    this.replaceField(nRowIndex, aValue.toString(), fieldDef.getFieldType(), fieldDef.getLength());
                }
            } else {
                fieldDef = this.m_nType != 2 ? this.m_vwTableDef.createFieldDefinition(aValue.toString(), this.m_nType, 0) : this.m_vwTableDef.createFieldDefinition(aValue.toString(), this.m_nType, this.m_nLength);
                if (fieldDef != null) {
                    VWConfigTableModelData tableData = new VWConfigTableModelData(fieldDef, 33);
                    this.m_rowData.addElement(tableData);
                    this.m_bIsModified = true;
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateFieldType(Object aValue, int nRowIndex) {
        try {
            if (aValue != null) {
                VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
                if (fieldDef != null) {
                    if (VWStringUtils.compare(VWFieldType.getLocalizedString(fieldDef.getFieldType()), aValue.toString()) != 0) {
                        if (VWStringUtils.compare(aValue.toString(), VWFieldType.getLocalizedString(1)) == 0) {
                            this.replaceField(nRowIndex, fieldDef.getName(), 1, 0);
                        } else if (VWStringUtils.compare(aValue.toString(), VWFieldType.getLocalizedString(2)) == 0) {
                            this.replaceField(nRowIndex, fieldDef.getName(), 2, this.m_nLength);
                        } else if (VWStringUtils.compare(aValue.toString(), VWFieldType.getLocalizedString(4)) == 0) {
                            this.replaceField(nRowIndex, fieldDef.getName(), 4, 0);
                        } else if (VWStringUtils.compare(aValue.toString(), VWFieldType.getLocalizedString(8)) == 0) {
                            this.replaceField(nRowIndex, fieldDef.getName(), 8, 0);
                        } else if (VWStringUtils.compare(aValue.toString(), VWFieldType.getLocalizedString(16)) == 0) {
                            this.replaceField(nRowIndex, fieldDef.getName(), 16, 0);
                        }
                    }
                } else {
                    this.m_nType = this.getFieldType(aValue.toString());
                }
                this.m_bIsModified = true;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateFieldLength(Object aValue, int nRowIndex) {
        VWExposedFieldDefinition fieldDef = null;
        try {
            if (aValue != null) {
                VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
                if (tableData != null) {
                    fieldDef = (VWExposedFieldDefinition)tableData.getDefinition();
                    if (fieldDef != null) {
                        fieldDef.setLength(Integer.parseInt(aValue.toString()));
                        tableData.setDirty();
                    }
                } else {
                    this.m_nLength = Integer.parseInt(aValue.toString());
                }
                this.m_bIsModified = true;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (NumberFormatException ex) {
            String msg = String.valueOf(nRowIndex + 1);
            if (fieldDef != null) {
                msg = msg + " (" + fieldDef.getName() + ")";
            }
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.InvalidDataFieldLength.toString(msg), VWResource.ErrorMessage, 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getFieldType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0) {
                return 16;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    protected VWExposedFieldDefinition getFieldItemAt(int nRowIndex) {
        VWConfigTableModelData tableData = this.getRowItemAt(nRowIndex);
        if (tableData != null) {
            return (VWExposedFieldDefinition)tableData.getDefinition();
        }
        return null;
    }

    private VWConfigTableModelData getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWConfigTableModelData)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public void replaceField(int nRowIndex, String theName, int theType, int theLength) {
        try {
            VWExposedFieldDefinition fieldDef = this.getFieldItemAt(nRowIndex);
            this.m_vwTableDef.deleteFieldDefinition(fieldDef.getName());
            this.m_rowData.removeElementAt(nRowIndex);
            VWExposedFieldDefinition newFieldDef = this.m_vwTableDef.createFieldDefinition(theName, theType, theLength);
            if (newFieldDef != null) {
                VWConfigTableModelData tableData = new VWConfigTableModelData(newFieldDef, 17);
                this.m_rowData.insertElementAt(tableData, nRowIndex);
            }
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
    }
}

